﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;


/* Blocking and interrupting: The Sleep() and Interrupt() methods */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;
        }

        object syncRoot = new object();
        SynchronizationContext synContext;
        Thread t = null;




        /* the thread procedure */
        void ThreadProc()
        {
            string S = "";
            try
            {
                if (chInfinite.Checked)
                    Thread.Sleep(Timeout.Infinite);
                else
                    Thread.Sleep(int.Parse(txtMSecs.Text));

                S = "thread terminated normally";
            }
            catch (ThreadInterruptedException ex)
            {
                S = "ThreadInterruptedException: " + ex.Message;
            }

            synContext.Send(SynchronizedMethod, S);
        }


        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void btnSleep_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))
            {
                t = new Thread(ThreadProc);
                t.Start();
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }

        private void btnInterrupt_Click(object sender, EventArgs e)
        {
            t.Interrupt();
        }
    }
}
